﻿/********************************************************************/
/*                                                                  */
/* ADOBE SYSTEMS INCORPORATED                                       */
/* Copyright 1986 - 2010 Adobe Systems Incorporated                 */
/* All Rights Reserved                                              */
/*                                                                  */
/* NOTICE:  Adobe permits you to use, modify, and distribute this   */
/* file in accordance with the terms of the Adobe license agreement */
/* accompanying it.  If you have received this file from a source   */
/* other than Adobe, then your use, modification, or distribution   */
/* of it requires the prior written permission of Adobe.            */
/*                                                                  */
/********************************************************************/
/*
 * Program Name:                                                     
 *    << FM_Flatten_Conrefs.jsx  >>                                                    
 *                                                                   
 * General Description:                                              
 *    This script flattens all the conrefs present in all the topic refs of th Active Ditamap/Topic
 *     One should run this script when the Active Ditamap/Topic is open in DOCUMENT VIEW
 *********************************************************************/      

#include "FM_lib.jsx"
 
 var mMenu = app.GetNamedMenu("!MakerMainMenu")
 
 var nMenu = mMenu.DefineAndAddMenu("DitaUtility", "DitaUtility")

var cm2=nMenu.DefineAndAddCommand(1,"Flatten conrefs" ,"Flatten conrefs in topicrefs","")
var cm2=nMenu.DefineAndAddCommand(2,"Flatten conrefs in ditamap" ,"Flatten conrefs in ditamap","")
UpdateMenus();

function Command(cmd) {
	
	switch(cmd) {
		
					
			case 1: /* it converts all the conrefs present in the active dita topic */
				var cnt = convertConref ()
				if (cnt!=0){
				Alert (cnt+" conrefs flattened",2)
				}
				break;
                
              case 2: /* it converts all the conrefs present in the active Ditamap */
                    Count = 0
                    tCount = 0
                    k=0
                    listOfFile = new Array()
                   var dmap = app.ActiveDoc
                    alt = Alert("All the Open files will be saved and closed and conrefs in the individual topicrefs will be converted to text .. Press OK to Continue or Cancel to Abort",Constants.FF_ALERT_OK_DEFAULT)
                    if (alt == 0) {
                    openAllTopicRefs(dmap.Name)
                    
                    
                    while( k < listOfFile.length )
                    {
                            var docTmp = openinvisible(listOfFile[k])
                            saveXml(docTmp,docTmp.Name) 
                            docTmp.Close(Constants.FF_CLOSE_MODIFIED)
                            k++
                     }
                  Alert("The total number of Conrefs converted is : " + tCount ,Constants.FF_ALERT_CONTINUE_NOTE)
                  } 
                    break;
			}
}

